#version 330
#extension GL_EXT_gpu_shader4 : enable
//alijaya - Raytracer againMod01.fsh  by  alijaya 

//https://www.shadertoy.com/view/XdyBWD
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

struct Ray {
    vec3 origin;
    vec3 direction;
};
    
struct Material {
    vec3 ambient;
    vec3 emission;
    vec3 diffuse;
    vec3 specular;
    float shininess;
};

struct HitInfo {
    Ray ray;
    bool isHit;
    float dist;
    vec3 normal;
    Material material;
};

struct Sphere {
    vec3 center;
    float radius;
    Material material;
};

struct Light {
    bool directional;
    vec3 position;
    vec3 color;
    float attenuation_constant;
    float attenuation_linear;
    float attenuation_quadratic;
};

vec3 camera_position;
vec3 camera_target;
vec3 camera_up;
float aspect;
float fovy;
vec2 mouse;
float PI = acos(-1.);
float EPS = 0.001;
vec3 ambientLight;
Light lights[4];
int numLights = 0;
const int maxDepth = 2;

void addLight( Light light ) {
    lights[numLights] = light;
    numLights++;
}

HitInfo hitSphere( Ray ray, Sphere sphere ) {
    // p = o + d * t
    // (p - c) . (p - c) - r * r = 0
    // (o + d * t - c) . (o + d * t - c) - r * r = 0
    // (d . d) tt + 2 (d . (o - c)) t + ((o - c) . (o - c) - rr) = 0
    
    
    vec3 co = ray.origin - sphere.center;
    float a = dot(ray.direction, ray.direction);
    float b = 2. * dot(ray.direction, co);
    float c = dot(co, co) - sphere.radius * sphere.radius;
    
    float det = b * b - 4. * a * c;
    
    HitInfo hit;
    hit.ray = ray;
    if (det < 0.) {
        hit.isHit = false;
    } else {
        hit.isHit = true;
        
        float t1 = (-b + sqrt(det)) / (2. * a);
        float t2 = (-b - sqrt(det)) / (2. * a);
        
        if (t1 < 0. && t2 < 0.) {
            hit.isHit = false;
        } else if (t1 < 0.) {
            hit.dist = t2;
        } else if (t2 < 0.) {
            hit.dist = t1;
        } else {
            hit.dist = min(t1, t2);
        }
    }
    
    if (hit.isHit) {
        vec3 p = ray.origin + ray.direction * hit.dist;
        hit.normal = normalize(p - sphere.center);
        hit.material = sphere.material;
    }
    
    return hit;
}

HitInfo selectHit( HitInfo a, HitInfo b ) {
    if (!a.isHit) return b;
    if (!b.isHit) return a;
    if (a.dist < b.dist) return a;
    else return b;
}

HitInfo castRay( Ray ray ) {
    HitInfo hit;
    
    for (float i=0.; i<5.; i++) {
        for (float j=0.; j<5.; j++) {
            Sphere sp;
            sp.center = vec3(j-2., i-2., 2.*sin(3.*iTime+i+j));
            sp.radius = 0.4;
            sp.material.ambient = vec3(1.);
            sp.material.diffuse = vec3(i/5., 1., 1.);
            sp.material.specular = vec3(0.5);
            sp.material.shininess = (j+1.) * 10.;
            
            hit = selectHit(hit, hitSphere(ray, sp));
        }
    }
    
    return hit;
}

HitInfo castRayToLight( Ray ray ) {
    HitInfo hit;
    
    for (int i=0; i<numLights; i++) {
        Light l = lights[i];
        Sphere sp;
        sp.center = l.position;
        sp.radius = 0.1;
        sp.material.emission = l.color;
        hit = selectHit(hit, hitSphere(ray, sp));
    }
    
    return hit;
}

vec3 getColor( HitInfo hit ) {
    HitInfo hitStack[maxDepth];
    int depth = 0;
    hitStack[depth] = hit;
    
    while (depth < maxDepth-1) {
        hit = hitStack[depth];
        if (!hit.isHit) break;
        if (dot(hit.material.specular, hit.material.specular) <= 0.) break;
        
        vec3 p = hit.ray.origin + hit.ray.direction * hit.dist;
        vec3 N = hit.normal;
        vec3 E = normalize(- hit.ray.direction);
        
        Ray ray;
        ray.direction = 2. * dot(N, E) * N - E;
        ray.origin = p + ray.direction * EPS;
        HitInfo h = castRay(ray);
        hitStack[depth+1] = h;
        
        depth++;
    }
    
    depth++;
    
    vec3 lastColor = vec3(0.);
    while (depth > 0) {
        depth--;
    	
        hit = hitStack[depth];
        if (!hit.isHit) {
            lastColor = vec3(0.);
            continue;
        }

        vec3 p = hit.ray.origin + hit.ray.direction * hit.dist;
        vec3 N = hit.normal;
        vec3 E = normalize(- hit.ray.direction);

        // reflection
        vec3 color = lastColor * hit.material.specular;

        // ambient
        color += ambientLight * hit.material.ambient + hit.material.emission;
        for (int i=0; i<numLights; i++) {
            Light l = lights[i];

            float dist = distance(l.position, p);
            
            vec3 L;
            if (l.directional) L = normalize(l.position);
            else L = normalize(l.position - p);
            
            vec3 H = normalize(E + L);

            // attenuation
            float attenuation;
            if (l.directional) attenuation = 1.;
            else attenuation = l.attenuation_quadratic * dist * dist +
                                l.attenuation_linear * dist +
                                l.attenuation_constant;

            // shadow
            Ray ray;
            ray.direction = L;
            ray.origin = p + ray.direction * EPS;
            HitInfo h = castRay(ray);

            if (!h.isHit || h.dist > dist) { // if there's no other object obstructing

                // diffuse
                color += l.color / attenuation * hit.material.diffuse * max(dot(N, L), 0.);

                // specular
                color += l.color / attenuation * hit.material.specular * pow(max(dot(N, H), 0.), hit.material.shininess);

            }
        }
        
        lastColor = color;
    }
    
    return lastColor;
}

vec3 getImage( vec2 coord ) {
    // setup camera
    float camera_distance = 6.;
    camera_position = vec3(-sin(mouse.x * PI) * camera_distance, mouse.y * camera_distance, -cos(mouse.x * PI) * camera_distance);
    camera_target = vec3(0., 0., 0.);
    camera_up = vec3(0., 1., 0.);
    fovy = 50.; // in degrees
    
    // setup lighting
    ambientLight = vec3(0., 0., 0.1);
    
    Light pl1;
    pl1.directional = false;
    pl1.position = vec3(4. * cos(3.*iTime), 4. * sin(3.*iTime), 2.);
    pl1.color = vec3(0.5);
    pl1.attenuation_quadratic = 0.1;
    addLight(pl1);
    
    Light pl2;
    pl2.directional = false;
    pl2.position = vec3(3. * cos(2.*iTime), 0., 3. * sin(2.*iTime));
    pl2.color = vec3(0.7, 0.3, 0.5);
    pl2.attenuation_linear = 0.3;
    addLight(pl2);
    
    Light dl1;
    dl1.directional = true;
    dl1.position = vec3(3., 3., 3.);
    dl1.color = vec3(0.7);
    addLight(dl1);
    
    Light dl2;
    dl2.directional = true;
    dl2.position = vec3(-3., -3., -3.);
    dl2.color = vec3(0.7, 0.3, 0.);
    addLight(dl2);
    
    // make camera coordinate
    vec3 w = normalize( camera_position - camera_target );
    vec3 u = normalize(cross( camera_up, w ));
    vec3 v = normalize(cross( w, u ));
    mat3 giri = mat3(u, v, w);
    
    float hasil_tan = tan(radians(fovy / 2.));
    vec3 ali;
    ali.y = hasil_tan * coord.y;
    ali.x = aspect * hasil_tan * coord.x;
    ali.z = -1.;
    
    Ray ray;
    ray.origin = camera_position;
    ray.direction = giri * ali;
    
    HitInfo hit = selectHit(castRay(ray), castRayToLight(ray));
    
    return getColor(hit);
}
void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    vec2 uv = gl_FragCoord.xy/iResolution.xy;
    uv -= 0.5;
    uv *= 2.;
    aspect = iResolution.x / iResolution.y;
    
    mouse = iMouse.xy/iResolution.xy;
    mouse -= 0.5;
    mouse *= 2.;
    
    //gl_FragColor = vec4(fract(uv), 1., 1.);
    gl_FragColor = vec4(getImage(uv), 1.);
}